/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.LocalBuffer;
import com.bonc.xcloud.convert.ByteOrderConv;
import com.bonc.xcloud.enumdef.CharSet;
import com.bonc.xcloud.util.NullValue;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class BasicTypeBuffer
extends LocalBuffer {
    public BasicTypeBuffer(boolean isLittleEnd) {
        super(isLittleEnd);
    }

    @Override
    public int getInt(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        boolean isNull = this.isNULL(row);
        if (isNull) {
            wasNull.setValue(isNull);
            return 0;
        }
        this.typeSize = 4;
        int pos = row * this.typeSize;
        if (isLE) {
            return ByteOrderConv.ConvByteToIntLE(this.m_array, pos);
        }
        return ByteBuffer.wrap(this.m_array, pos, this.typeSize).getInt();
    }

    @Override
    public boolean getBool(int row, boolean isLE, CharSet cs) {
        this.typeSize = 1;
        return false;
    }

    @Override
    public char getChar(int row, boolean isLE, CharSet cs) {
        this.typeSize = 1;
        return '\u0000';
    }

    @Override
    public byte getByte(int row, boolean isLE, CharSet cs) {
        this.typeSize = 1;
        return 0;
    }

    @Override
    public short getShort(int row, boolean isLE, CharSet cs) {
        this.typeSize = 2;
        return 0;
    }

    @Override
    public long getLong(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        boolean isNull = this.isNULL(row);
        if (isNull) {
            wasNull.setValue(isNull);
            return 0L;
        }
        this.typeSize = 8;
        int pos = row * this.typeSize;
        if (isLE) {
            return ByteOrderConv.ConvByteToLongLE(this.m_array, pos);
        }
        return ByteBuffer.wrap(this.m_array, pos, this.typeSize).getLong();
    }

    @Override
    public double getDouble(int row, boolean isLE, CharSet cs, NullValue wasNull) throws SQLException {
        this.typeSize = 8;
        long ret = this.getLong(row, isLE, cs, wasNull);
        return Double.longBitsToDouble(ret);
    }

    @Override
    public float getFloat(int row, boolean isLE, CharSet cs) {
        this.typeSize = 4;
        return 0.0f;
    }

    @Override
    public Object get(int row, boolean isLE, CharSet cs) {
        return null;
    }

    @Override
    public void arrayUpdate() throws SQLException {
    }
}

