/*
 * Decompiled with CFR 0.152.
 */
package com.bonc.xcloud.common;

import com.bonc.xcloud.common.ExceptionMgr;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.Enumeration;

public class BasicNetInfo {
    public static String getLocalMac() throws SQLException {
        byte[] mac = null;
        try {
            mac = BasicNetInfo.getMacId();
        }
        catch (Exception e) {
            String retMsg = ExceptionMgr.getConvertedErrorMsg("get Mac Addr err:" + e.getMessage());
            ExceptionMgr.throwSQLExp(retMsg);
        }
        if (mac == null) {
            return "0-0-0-0";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return sb.toString().toUpperCase();
    }

    private static byte[] getMacId() throws SocketException {
        byte[] macId = null;
        InetAddress ip = null;
        NetworkInterface ni = null;
        boolean bFindIP = false;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        block0: while (netInterfaces.hasMoreElements() && !bFindIP) {
            ni = netInterfaces.nextElement();
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                ip = ips.nextElement();
                if (ip.isLoopbackAddress() || !ip.getHostAddress().matches("(\\d{1,3}\\.){3}\\d{1,3}")) continue;
                bFindIP = true;
                continue block0;
            }
        }
        if (null != ip) {
            macId = ni.getHardwareAddress();
        }
        return macId;
    }
}

